import type { Metadata } from 'next'
import { Inter } from 'next/font/google'
import './globals.scss'
import 'bootstrap/dist/css/bootstrap.min.css'

const inter = Inter({ subsets: ['latin'] })

export const metadata: Metadata = {
  title: 'Weart Admin',
  description: '',
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="en">
      <body className={inter.className}>
        <div className='w-100 h-100 d-flex align-items-center justify-content-center'>
          {children}
        </div>
      </body>
    </html>
  )
}
