import React from 'react'
import { Row, Col, Toast } from 'react-bootstrap';
import ProductCard from '../ProductCard/ProductCard';
import Image from 'next/image';
import Link from 'next/link';
import { useRouter } from 'next/navigation';
import { ToastContainer, toast } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';

interface Props {
  id: number;
  name: string;
  image: string;
  typeURL: string
}

const NewCustomProduct: React.FC<Props> = ({ id, name, image, typeURL }) => {

  const router = useRouter();

  const [type, setType] = React.useState<string>('Texto simples')

  const handleSubmit = () => {
    console.log(type)
    if (type === 'Texto simples') {
      router.push(`/simple_text/${id}?name=${name}&image=${image}&type=${type}`)
    }
    if (type === 'Pré-determinada') {
      console.log('aaapre determinada')
      router.push(`/pre_determinated/${id}?name=${name}&image=${image}&type=${type}`)
    }
    if (type === 'Upload de PDF') {
      router.push(`/upload_pdf/${id}?name=${name}&image=${image}&type=${type}`)
    }
  }
  
  const handleBack = () => {
    router.push(`/custom_product?type=${typeURL}`)
  }
  

  return (
    <div className='w-80 px-5'>
      <div className='bg-light rounded-4 p-3'>
        <Row>
          <Col lg={7} className="">
            <h4 className='fw-bold mb-4'>Customização de produto</h4>
            <div className='d-flex flex-column'>
              <form>
                <div className='form-check mb-2'>
                  <input
                    onChange={(e) => setType(e.target.value)}
                    value='Texto simples'
                    id=""
                    className='form-check-input'
                    type="radio"
                    name="type"
                    defaultChecked
                  />
                  <label className="form-check-label" htmlFor="">
                    Texto simples
                  </label>
                </div>
                <div className='form-check mb-2'>
                  <input
                    onChange={(e) => setType(e.target.value)}
                    value='Pré-determinada'
                    id=""
                    className='form-check-input'
                    type="radio"
                    name="type"
                  />
                  <label className="form-check-label" htmlFor="">
                    Pré-determinada
                  </label>
                </div>
                <div className='form-check mb-2'>
                  <input
                    onChange={(e) => setType(e.target.value)}
                    value='Upload de PDF'
                    id=""
                    className='form-check-input'
                    type="radio"
                    name="type"
                  />
                  <label className="form-check-label" htmlFor="">
                    Upload de PDF
                  </label>
                </div>
              </form>
            </div>
          </Col>
          <Col lg={5}>
            <ProductCard id={id} name={name} image={image} />
            <div>
              <div className='d-flex justify-content-end'>
                <button onClick={e => handleBack()} className='btn btn-dark fs-7 me-3'>
                  Voltar
                </button>
                <button onClick={e => handleSubmit()} className='btn btn-primary fs-7'>
                  Continuar
                  <Image src="/svg/arrow-right.svg" className="ms-2" width={16} height={16} alt="" />
                </button>
              </div>
            </div>
          </Col>
        </Row>
      </div>
      <ToastContainer />
    </div>
  )
}

export default NewCustomProduct