import React from 'react'
interface ProductCardProps {
    id: number;
    name: string;
    image: string;
}

const ProductCard: React.FC<ProductCardProps> = ({ id, name, image }) => {
    return (
        <div className='d-flex align-items-center shadow rounded mb-3 p-3'>
            <div className='me-4'>
                <img src={image ?? ''} width={90} height={90} alt=''/>
            </div>
            <div>
                <div className='fs-7'>
                    {name}
                </div>
            </div>
        </div>
    )
}

export default ProductCard