import React, { use, useEffect, useState } from 'react'
import { Row, Col } from 'react-bootstrap'
import Image from 'next/image'
import api from '@/utils/api'
import SearchInput from './../SearchInput/SearchInput';
import { toast, ToastContainer } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';
import { useRouter } from 'next/navigation';

interface KitPanelProps {
    id: number;
    name: string;
    image: string;
    typeURL: string;
}
interface KitItem {
    id: number;
    createdAt: string;
    updatedAt: string;
    paiId: number;
    filhoId: number;
    Pai: Father;
    Filho: Child;
}

interface Father {
    store_id: number;
    id: number;
    nome: string;
    foto: string;
    createdAt: string;
    updatedAt: string;
}

interface Child {
    store_id: number;
    id: number;
    nome: string;
    foto: string;
    createdAt: string;
    updatedAt: string;
}

interface NewKitItem {
    paiId: number;
    filhoId: number;
}

const KitPanel: React.FC<KitPanelProps> = ({ id, name, image, typeURL }) => {

    const STORE_ID = process.env.NEXT_PUBLIC_STORE_ID;

    const router = useRouter()

    const [kitItems, setKitItems] = useState<KitItem[]>([])

    const [newKitItems, setNewKitItems] = useState<Product[]>([])

    const [query, setQuery] = useState<string>()

    const [nuvemProducts, setNuvemProducts] = useState<Product[]>([])

    //get items on kit
    const getItemsOnKit = async () => {
        try {
            const response = await api.get(`/kit?offset=0&limit=20&paiId=${id}`)
            setKitItems(response.data[0])
            console.log(response.data[0])
        } catch (error) {
            console.log(error)
        }
    }

    useEffect(() => {
        getItemsOnKit()
    }, [])

    //get products from nuvem
    useEffect(() => {
        const getProducts = async () => {
            try {
                let url = `/product?offset=0&limit=20&store_id=${STORE_ID}`
                if (query) {
                    url += `&search=${query}`
                }
                const response = await api.get(url)
                setNuvemProducts(response.data[0])
            } catch (error) {

            }
        }
        getProducts()
    }, [query])

    const handleAddItem = (product: Product) => {
        setNewKitItems([...newKitItems, product])
    }

    const handleRemoveItem = (product: Product) => {
        const newItems = newKitItems.filter(item => item.id !== product.id)
        setNewKitItems(newItems)
    }

    const handleRemoveKitItem = async (item: KitItem) => {
        try {
            const response = await api.delete(`/kit/${item.id}`)
            console.log(response)
            setKitItems(kitItems.filter(kitItem => kitItem.id !== item.id))
            toast.success('Item removido do kit com sucesso!')
        } catch (error) {
            console.log(error)
            toast.error('Erro ao remover item do kit!')
        }
    }

    const handleSave = () => {

        newKitItems.forEach(async (item) => {
            const newItem: NewKitItem = {
                paiId: id,
                filhoId: item.id
            }

            try {
                const response = await api.post('/kit', newItem)
                console.log(response)
                toast.success('Item adicionado ao kit com sucesso!')
            } catch (error) {
                console.log(error)
                toast.error('Erro ao adicionar item ao kit!')
            }
        })

        getItemsOnKit()
        setNewKitItems([])
    }


    const handleBack = () => {
        router.push(`/custom_product?type=${typeURL}`)
    }
    useEffect(() => {
        console.log('kitItems', newKitItems)
    }, [newKitItems])

    return (
        <div className='w-80 bg-light overflow-y-scroll rounded-4' style={{ maxHeight: '530px' }}>
            <div className='w-80 position-fixed bg-body rounded-4 shadow-sm p-2 z-1'>
                <h5 className='fw-bold text-center mb-0'>{name}</h5>
            </div>
            <div className='mt-4 p-3'>
                <Row className='mb-3'>
                    <Col lg={4}>
                        <div className='h-100 d-flex flex-column justify-content-between'>
                            <div className='d-flex flex-column align-items-center'>

                                <Image src={image} width={256} height={256} alt={name} />
                            </div>
                            <div>
                                <button onClick={e => handleBack()} className='btn btn-dark'>Voltar</button>
                            </div>
                        </div>
                    </Col>
                    <Col className='d-flex flex-column justify-content-between'>
                        <div className=' mb-2' >
                            <div className=''>
                                <div className='  p-2'>
                                    <Row className=''>
                                        <Col lg={6}>
                                            <h4>Itens no kit:</h4>
                                            <div className='bg-body overflow-y-scroll overflow-x-hidden shadow-sm rounded p-2' style={{ height: '256px' }}>
                                                <Row>
                                                    {kitItems.map((item, i) => (
                                                        <Col key={i} lg={6} className='mb-3'>
                                                            <div className='d-flex flex-column align-items-center card p-2'>
                                                                <Image src={item.Filho.foto} className='mb-2' width={90} height={90} alt='' />
                                                                <div className='text-center overflow-hidden fs-7 h-3'>{item.Filho.nome}</div>
                                                                <button onClick={e => handleRemoveKitItem(item)} className='btn btn-danger fs-7'>Remover</button>
                                                            </div>
                                                        </Col>
                                                    ))}
                                                </Row>
                                            </div>
                                        </Col>
                                        <Col lg={6}>
                                            <h4>Novos itens:</h4>
                                            <div className='bg-body overflow-y-scroll overflow-x-hidden shadow-sm rounded p-2' style={{ height: '256px' }}>
                                                <Row>
                                                    {newKitItems.map((item, i) => (
                                                        <Col key={i} lg={6} className='mb-3'>
                                                            <div className='d-flex flex-column align-items-center card p-2'>
                                                                <Image src={item.foto} className='mb-2' width={90} height={90} alt='' />
                                                                <div className='text-center overflow-hidden fs-7 h-3'>{item.nome}</div>
                                                                <button onClick={e => handleRemoveItem(item)} className='btn btn-danger fs-7'>Remover</button>
                                                            </div>
                                                        </Col>
                                                    ))}
                                                </Row>
                                            </div>
                                        </Col>
                                    </Row>
                                </div>
                            </div>
                        </div>
                        <div className='d-flex justify-content-end'>
                            <button onClick={e => handleSave()} className='btn btn-success'>Salvar</button>
                        </div>
                    </Col>
                </Row>
                <Row>
                    <Col lg={12}>
                        <div>
                            <div>
                                <SearchInput setQuery={setQuery} />
                            </div>
                            <div className='bg-body overflow-y-scroll p-3' style={{ height: '300px' }}>
                                <Row>
                                    {nuvemProducts.map((product, i) => (
                                        <Col key={i} lg={3}>
                                            <div className='d-flex flex-column align-items-center card p-3 mb-2'>
                                                <Image src={product.foto} className='mb-2' width={90} height={90} alt='' />
                                                <div className='text-center fs-7 h-3'>{product.nome}</div>
                                                <button onClick={e => handleAddItem(product)} className='btn btn-primary'>Adicionar</button>
                                            </div>
                                        </Col>
                                    ))}
                                </Row>
                            </div>
                        </div>
                    </Col>
                </Row>
            </div>
            <ToastContainer />
        </div>
    )
}

export default KitPanel