import React from 'react'
import Image from 'next/image';

interface SearchInputProps {
    setQuery: (value: string) => void
}


const SearchInput: React.FC<SearchInputProps> = ({ setQuery }) => {

    

    const handleSearch = (value: string) => {
        setQuery(value)
        console.log(value)
    }

    return (
        <div className='position-relative mb-3'>
            <input onChange={e => handleSearch(e.target.value)} className="w-100 border fs-7 btn-outline-light rounded py-2 px-3" type="text" placeholder='Busque pelo nome do produto' />
            <button className='btn position-absolute p-0' style={{ right: '8px', top: '5px' }}>
                <Image src='/svg/search.svg' width={16} height={16} alt='' />
            </button>
        </div>
    )
}

export default SearchInput