import React, { useState } from 'react'
import { Row, Col } from 'react-bootstrap'
import ProductCard from '../ProductCard/ProductCard';
import Image from 'next/image';
import api from '@/utils/api';

import { toast, ToastContainer } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css'; 'react-toastify';

interface Props {
    id: number;
    name: string;
    image: string;

}

const UploadPDF: React.FC<Props> = ({ id, name, image }) => {

    const [hide, setHide] = useState<boolean>(false)
    const [required, setRequired] = useState<boolean>(false)

    const [variationName, setVariationName] = useState<string>()


    const sendValues = async () => {
        if (!variationName) return toast.error('Preencha o nome da variante!')
        
        const data = {
            productId: id,
            nome: variationName,
            tipo: 'arquivo',
            fonte: false,
            cor: false,
            imagem: false,
            ocultoCart: hide,
            required: required,
            preview: false
        }
        console.log(data)
        try {
            const response = await Promise.resolve(api.post('/variant', data))

            toast.success('Variante criada com sucesso!')
            console.log(response)
        } catch (error) {
            toast.error('Erro ao criar variante!')
            console.log(error)
        }
    }

    return (
        <div className='w-80 bg-light rounded-4 p-3'>
            <Row>
                <Col lg={6}>
                    <h4>Upload de PDF</h4>
                    <div className=''>
                        <div className=''>
                            <label htmlFor="">Nome:</label>
                            <input onChange={e => setVariationName(e.target.value)} className='form-control' type="text" />
                        </div>
                        <div className='form-check'>
                            <label htmlFor="">Ocultar no carrinho</label>
                            <input checked={hide} onChange={e => setHide(!hide)} type="checkbox" className='form-check-input' name="" id="" />
                        </div>
                        <div className='form-check'>
                            <label htmlFor="">Obrigatório</label>
                            <input checked={required} onChange={e => setRequired(!required)} type="checkbox" className='form-check-input' name="" id="" />
                        </div>
                    </div>

                </Col>
                <Col lg={6}>
                    <ProductCard id={id} name={name} image={image} />
                    <div className='d-flex justify-content-end'>
                        <button onClick={e => sendValues()} className='d-flex align-items-center btn btn-success me-2'>Salvar
                            <Image src='/svg/save.svg' className='ms-2' width={20} height={20} alt='' />
                        </button>
                        <button onClick={e => {window.history.back()}} className='btn btn-dark'>Voltar</button>
                    </div>
                </Col>
            </Row>
            <ToastContainer />
        </div>
    )
}

export default UploadPDF